<?php 

class M_bukukas extends CI_Model{
	public function __construct()
	{
		$this->load->database();
	}
	 
	public function bukukas()
	{
		date_default_timezone_get('Asia/Jakarta');
		$bulan = date('m');
		$tahun = date('Y');
		$this->db->order_by('date', 'desc');
		$this->db->order_by('keterangan', 'asc');
		$this->db->where('month(tb_bukukas.date)',$bulan);
		$this->db->where('year(tb_bukukas.date)',$tahun); 
		$query = $this->db->get('tb_bukukas');
		return $query->result();
	} 
	public function get_bukukas($start_date, $end_date) {
	    $this->db->where('date >=', $start_date);
	    $this->db->where('date <=', $end_date);
	    $this->db->order_by('date', 'desc');
	    return $this->db->get('tb_bukukas')->result();
	}
	public function bukukas_bulanan()
	{
		date_default_timezone_set('Asia/Jakarta');
		$bulan = date('m');
		$tahun = date('Y');
		$this->db->order_by('date', 'asc');
		$this->db->order_by('keterangan', 'asc');
		$this->db->where('month(tb_bukukas.date)',$bulan);
		$this->db->where('year(tb_bukukas.date)',$tahun); 
		$query = $this->db->get('tb_bukukas');
		return $query->result();
	} 
 	
	public function get_bukukas_list($limit, $start){
		date_default_timezone_get('Asia/Jakarta');
		// $bulan = date('m');
		// $tahun = date('Y');
		$this->db->order_by('date', 'desc');
		$this->db->order_by('keterangan', 'asc');
		// $this->db->where('month(tb_bukukas.date)',$bulan);
		// $this->db->where('year(tb_bukukas.date)',$tahun); 
		$query = $this->db->get('tb_bukukas', $limit, $start);
		return $query;
	} 
     
	 
	 function laporan($jenis_laporan,$tanggal, $id_kantor_cari,$bulan,$tahun,	$tanggal_awal,	$tanggal_akhir,$id_admin){

		if($jenis_laporan =='harian'){
			 
				$query = $this->db->query("select  * from tb_bukukas where date(tb_bukukas.date) = '$tanggal'  order by tb_bukukas.date asc,tb_bukukas.keterangan asc ");
			 

		}else  if($jenis_laporan =='bulanan'){
			 
				 $query = $this->db->query("select  * from tb_bukukas where month(tb_bukukas.date)='$bulan' and year(tb_bukukas.date)='$tahun'  order by tb_bukukas.date asc,tb_bukukas.keterangan asc");
			 
				
		}else  if($jenis_laporan =='pilihan'){
			 
				if($id_admin == 'all'){
					$query = $this->db->query("select  * from tb_bukukas where  tb_bukukas.date BETWEEN '$tanggal_awal' AND '$tanggal_akhir'    order by tb_bukukas.date asc,tb_bukukas.keterangan asc ");
				}else{
					$query = $this->db->query("select  * from tb_bukukas  where  tb_bukukas.date BETWEEN '$tanggal_awal' AND '$tanggal_akhir' and tb_bukukas.id_admin ='$id_admin'    order by tb_bukukas.date asc,tb_bukukas.keterangan asc ");
				}

				  
			 
		
		} 

        return $query->result();
    }
    public function get_by_date_range($tgl_awal, $tgl_akhir) {
        $this->db->where('date >=', $tgl_awal);
        $this->db->where('date <=', $tgl_akhir);
        $this->db->order_by('date', 'DESC');
        return $this->db->get('tb_bukukas')->result();
    }

 
    public function get_all($tgl_awal = null, $tgl_akhir = null) {
        if(!$tgl_awal) $tgl_awal = date('Y-m-01');
        if(!$tgl_akhir) $tgl_akhir = date('Y-m-t');
        
        $this->db->where('date >=', $tgl_awal);
        $this->db->where('date <=', $tgl_akhir);
        return $this->db->get('tb_bukukas')->result();
    }

    public function get_by_id($id) {
        return $this->db->get_where('tb_bukukas', ['id_bukukas' => $id])->row();
    }

    public function insert($data) {
        $this->db->insert('tb_bukukas', $data);
        return $this->db->insert_id();
    }

    public function update($id, $data) {
        $this->db->where('id_bukukas', $id);
        return $this->db->update('tb_bukukas', $data);
    }

    public function delete($id) {
        $this->db->where('id_bukukas', $id);
        return $this->db->delete('tb_bukukas');
    }
    // Tambahkan method untuk menghitung total
    public function get_totals($tgl_awal = null, $tgl_akhir = null) {
    	if(!$tgl_awal) $tgl_awal = date('Y-m-01');
    	if(!$tgl_akhir) $tgl_akhir = date('Y-m-t');
    	
    	$this->db->select_sum('nominal', 'total');
    	$this->db->where('jenis', 'pemasukan');
    	$this->db->where('date >=', $tgl_awal);
    	$this->db->where('date <=', $tgl_akhir);
    	$pemasukan = $this->db->get('tb_bukukas')->row()->total;
    	
    	$this->db->select_sum('nominal', 'total');
    	$this->db->where('jenis', 'pengeluaran');
    	$this->db->where('date >=', $tgl_awal);
    	$this->db->where('date <=', $tgl_akhir);
    	$pengeluaran = $this->db->get('tb_bukukas')->row()->total;
    	
    	return [
    		'pemasukan' => $pemasukan ? $pemasukan : 0,
    		'pengeluaran' => $pengeluaran ? $pengeluaran : 0
    	];
    }

}