<?php 

class Member extends CI_Controller{

	function __construct(){
		parent::__construct();
	 	$this->load->model('m_kontak');/* sesuaikan dengan nama file pada model */
		$this->load->model('m_login'); 
		$this->load->model('m_admin'); 
		$this->load->model('m_kantor');
		$this->load->model('m_kat_member'); 
		$this->load->model('m_member'); 
		$this->load->library('session');
		$this->load->library('upload');
		 
		$this->load->helper(array('form', 'url','tanggal'));
		if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
			$this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<strong> Admin Bukan Admin </strong>Ulangi Kembali
						</div> ');

			redirect(base_url("")); 
			
		}
	 
	 
	}

	 
	function index(){		
		$data['title1'] = 'Data Member'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Member';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['member'] = $this->m_member->member(); 
		$data['kat_member'] = $this->m_kat_member->kat_member(); 
		$data['kat_member1'] = $this->m_kat_member->kat_member(); 
		 
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/member/v_member');
		$this->load->view('master/footer',$data); 
	}
	
	function history_point(){		
		$data['title1'] = 'Data History Point Member'; 	
		$data['title2'] = 'Data History Point '; 	
	 
		$data['title4'] = 'Member';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['member'] = $this->m_member->member(); 
		 
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/member/v_history_point');
		$this->load->view('master/footer',$data); 
	}
	function tampil_data_point(){		
		$ktp= $this->input->post('ktp');

		$data['title1'] = 'Tampil History Point Member'; 	
		$data['title2'] = 'Data History Point '; 	
	 
		$data['title4'] = 'Member';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['member'] = $this->m_member->cari_member($ktp); 

		$data['tampil'] = $this->m_member->history_point($ktp); 
		 
		 
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/member/v_tampil_history_point',$data);
		$this->load->view('master/footer',$data); 
	}
	 
	public function code_hapus(){
		$id = $this->input->post('id');  
		 
	    $this->db->delete('tb_member', array('id_member' => $id)); 
	  	$this->session->set_flashdata('msg','success-hapus');
	    redirect('member');
		
	}
	 
	public function code_tambah()
	{	 
			$data=array(
				'id_member'=>  null,
				'nama_member'=> $this->input->post('nama_member'),
				'id_kat_member'=> $this->input->post('id_kat_member'),
				'ktp'=> $this->input->post('ktp'),
				'hp'=> $this->input->post('hp'),
				'alamat'=> $this->input->post('alamat'),
				'date'=> date('Y-m-d')
				 			 
			);

			$this->db->insert('tb_member',$data);
			$this->session->set_flashdata('msg','success');
			redirect('member');


 
        
        
    }  

    public function code_tambah_kasir()
	{	 
			$data=array(
				'id_member'=>  null,
				'nama_member'=> $this->input->post('nama_member'),
				'id_kat_member'=> $this->input->post('id_kat_member'),
				'ktp'=> $this->input->post('ktp'),
				'hp'=> $this->input->post('hp'),
				'alamat'=> $this->input->post('alamat'),
				'date'=> date('Y-m-d')
				 			 
			);
			$this->db->insert('tb_member',$data);
			$this->session->set_flashdata('msg','success');
			redirect('kasir/log_in');


 
        
        
    } 
     
	public function code_ubah() {
      
        
    	$data=array(
    	 
    		'nama_member'=> $this->input->post('nama_member'),
    			'id_kat_member'=> $this->input->post('id_kat_member'),
    		'ktp'=> $this->input->post('ktp'),
    		'hp'=> $this->input->post('hp'),
    		'alamat'=> $this->input->post('alamat'),
    		'point'=> $this->input->post('point'),

    	);

    	$this->db->where('id_member',$this->input->post('id'));
        $this->db->update('tb_member',$data);
        $this->session->set_flashdata('msg','success-edit');
    	redirect('member');
	 
	} 
	 
}