<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kasirbaru extends CI_Controller {

    public function __construct() {
        parent::__construct();
        
        
    }

    public function index() {
        $data['title'] = 'Kasir';
        $this->load->view('kasirq/index', $data);
    }

    // Cari barang untuk autocomplete
    public function cari_barang() {
        $keyword = $this->input->get('term');
        $data = $this->Transaksi_model->cari_barang($keyword);
        
        $response = array();
        foreach($data as $barang) {
            $response[] = array(
                'id' => $barang->id,
                'value' => $barang->nama_barang,
                'barcode' => $barang->barcode_ecer,
                'harga' => $barang->harga_jual_ecer
            );
        }
        
        echo json_encode($response);
    }

    // Get barang by barcode
    public function get_barang_by_barcode() {
        $barcode = $this->input->post('barcode');
        $barang = $this->Transaksi_model->get_barang_by_barcode($barcode);
        
        if($barang) {
            $response = array(
                'status' => true,
                'data' => array(
                    'id' => $barang->id,
                    'nama' => $barang->nama_barang,
                    'barcode' => $barang->barcode_ecer,
                    'harga' => $barang->harga_jual_ecer
                )
            );
        } else {
            $response = array(
                'status' => false,
                'message' => 'Barang tidak ditemukan'
            );
        }
        
        echo json_encode($response);
    }

    // Proses transaksi
    public function proses_transaksi() {
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('sub_total', 'Sub Total', 'required');
        $this->form_validation->set_rules('total', 'Total', 'required');
        $this->form_validation->set_rules('bayar', 'Bayar', 'required');
        $this->form_validation->set_rules('kembali', 'Kembali', 'required');
        $this->form_validation->set_rules('metode_bayar', 'Metode Bayar', 'required');
        
        if($this->form_validation->run() == FALSE) {
            $response = array(
                'status' => false,
                'message' => validation_errors()
            );
        } else {
            // Generate ID Transaksi
            $id_transaksi = $this->Transaksi_model->generate_id_transaksi();
            
            // Data Transaksi
            $data_transaksi = array(
                'id_transaksi' => $id_transaksi,
                'sub_total' => str_replace('.', '', $this->input->post('sub_total')),
                'total' => str_replace('.', '', $this->input->post('total')),
                'bayar' => str_replace('.', '', $this->input->post('bayar')),
                'kembali' => str_replace('.', '', $this->input->post('kembali')),
                'status' => 'success',
                'metode_bayar' => $this->input->post('metode_bayar'),
                'ket_metode' => $this->input->post('ket_metode')
            );
            
            // Data Detail Transaksi
            $detail_transaksi = array();
            foreach($this->input->post('id_barang') as $key => $id_barang) {
                $detail_transaksi[] = array(
                    'id_transaksi' => $id_transaksi,
                    'id_barang' => $id_barang,
                    'harga_beli' => str_replace('.', '', $this->input->post('harga_beli')[$key]),
                    'harga_jual' => str_replace('.', '', $this->input->post('harga_jual')[$key]),
                    'jumlah' => $this->input->post('jumlah')[$key],
                    'harga_total' => str_replace('.', '', $this->input->post('harga_total')[$key])
                );
            }
            
            // Simpan transaksi
            $simpan = $this->Transaksi_model->simpan_transaksi($data_transaksi, $detail_transaksi);
            
            if($simpan) {
                $response = array(
                    'status' => true,
                    'message' => 'Transaksi berhasil disimpan',
                    'id_transaksi' => $id_transaksi
                );
            } else {
                $response = array(
                    'status' => false,
                    'message' => 'Gagal menyimpan transaksi'
                );
            }
        }
        
        echo json_encode($response);
    }
}