<?php 

class M_barang extends CI_Model{
	public function __construct()
	{
		$this->load->database();
	}
  function get_all_product() {
      $this->datatables->select('barcode_ecer,nama_barang,harga_beli_ecer,harga_jual_ecer,id_satuan_jual');
      $this->datatables->from('tb_barang');
 
      $this->datatables->add_column('view', '<a href="javascript:void(0);" class="edit_record btn btn-info" data-code="$1" data-name="$2" data-price="$3" data-category="$4">Edit</a>  <a href="javascript:void(0);" class="delete_record btn btn-danger" data-code="$1">Delete</a>','barcode_ecer,nama_barang,harga_beli_ecer,harga_jual_ecer,id_satuan_jual');
      return $this->datatables->generate();
  }
  function barang_list(){
                $hasil=$this->db->query("SELECT * FROM tb_barang");
                return $hasil->result();
        }
 
  public function get_all_data()
    {
        $projects = $this->db->get("tb_barang")->result();
        return $projects;
    }
  public function getData()
    {
        $hasil=$this->db->query("SELECT * FROM tb_barang ");
        return $hasil->result();
    }
	public function barang()
	{
		$this->db->order_by('date', 'desc');
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	public function barang_edit()
	{	
		$barcode=$this->uri->segment(3);
		$this->db->order_by('date', 'desc');
		$this->db->where('barcode_ecer', $barcode);
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	public function barang_cek()
	{
		$this->db->order_by('date', 'desc');

		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	public function edit_barang($id_barang)
	{
		$barcode=$this->uri->segment(3);
		$this->db->where('barcode_ecer', $barcode);
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	public function label_barang($id_barang)
	{
		$this->db->where('id', $id_barang);
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	public function jumlah_data_barang(){
       
      
        return $this->db->get('tb_barang')->num_rows();

    }
    public function tampilkan($limit, $start){
     
		$cari=  $this->input->post('cari');
		if(!empty($cari)){
       $query = $this->db->like('nama_barang',$cari);
		 	$query =$this->db->or_like('barcode_ecer',$cari);
		  
			$query = $this->db->get('tb_barang', $limit, $start);
		}else{
			$this->db->order_by('id', 'desc');
		$this->db->order_by('date', 'asc');
	 	$query = $this->db->get('tb_barang', $limit, $start);
		}
        return $query;
    }
	 
	public function barang_nama_cetak()
	{
		
		$this->db->order_by('id_rak', 'asc');
    	$this->db->order_by('id_selfing', 'asc');
		$this->db->order_by('id_katagori', 'asc');
		$this->db->order_by('nama_barang', 'asc');
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	public function barang_nama_cetak_baru()
	{
		
		$this->db->order_by('id_rak', 'asc');
    	$this->db->order_by('id_selfing', 'asc');
		$this->db->order_by('id_katagori', 'asc');
		$this->db->order_by('nama_barang', 'asc');
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
  public function barang_nama()
  {
    
    $this->db->order_by('id_rak', 'asc');
    
    $this->db->order_by('id_katagori', 'asc');
    $this->db->order_by('nama_barang', 'asc');
    $query = $this->db->get('tb_barang');
    return $query->result();
  } 
	public function barcode_list()
	{
		$this->db->order_by('id', 'asc');
		$query = $this->db->get('tb_cetak_barcode');
		return $query->result();
	} 
	public function label_list()
	{
		$this->db->order_by('id_label', 'asc');
		$query = $this->db->get('tb_label');
		return $query->result();
	} 
	public function label_list_all()
	{
		$this->db->order_by('nama_barang', 'asc');
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	function struk($id_barang)
	{
		 
		 
	 	$this->db->where('id',$id_barang);
		 
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 
	public function barang_rak()
	{
		$id_rak = $this->uri->segment(3);
		$this->db->where('id_rak',$id_rak);
		$query = $this->db->get('tb_barang');
		return $query->result();
	} 

	public function cetak_barang_history($id_kantor,$id_barang)
	{
	 	$this->db->order_by('id_history', 'asc');
		$this->db->where('id_kantor',$id_kantor);
	 
		$this->db->where('id_barang',$id_barang);
		$query = $this->db->get('tb_history_barang_in_out');
		return $query->result();
	}


	public function cetak_barang_terjual($id_kantor,$bulan,$tahun)
	{ 
	   $query = $this->db->query("select  id_barang, sum(tb_jual_detail.jumlah) as total from tb_jual_detail WHERE 
		month(tb_jual_detail.date)='$bulan' AND  
		year(tb_jual_detail.date)='$tahun' AND 
		tb_jual_detail.id_kantor='$id_kantor' GROUP BY tb_jual_detail.id_barang ORDER BY  total desc ");
		 
		return $query->result();
	} 
	public function cetak_barang_terjual_harian($id_kantor,$tanggal)
	{ 
	   $query = $this->db->query("select  id_barang, sum(tb_jual_detail.jumlah) as total from tb_jual_detail WHERE 
		date(tb_jual_detail.date)='$tanggal' AND  
	  
		tb_jual_detail.id_kantor='$id_kantor' GROUP BY tb_jual_detail.id_barang ORDER BY  total desc ");
		 
		return $query->result();
	} 
	public function barang_expired($id_admin,$id_kantor,$level)
    {
        date_default_timezone_get('Asia/Jakarta');
        $tanggal_sekarang = date('Y-m-d');
        $tambah_tanggal = mktime(0,0,0,date('m')+4,date('01'),date('Y'));
        $tambah = date('Y-m-d',$tambah_tanggal);
        if($level =='manager'){
        	$this->db->order_by('tb_info_expired.expired_date', 'asc');
        	 $this->db->limit(10); 
        	$this->db->where('tb_info_expired.expired_date <=',$tambah);
        	$query = $this->db->get('tb_info_expired');

        }else{
        	$this->db->order_by('tb_info_expired.expired_date', 'asc');
        	 $this->db->limit(10);
        	$this->db->where('id_admin',$id_admin);
        	$this->db->where('id_kantor',$id_kantor);
        	$this->db->where('tb_info_expired.expired_date <=',$tambah);
        	$query = $this->db->get('tb_info_expired');
        }
       
        return $query->result();
    } 

    function history_barang($limit, $start){
    	$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin_login']= $row->id;
		$id_admin = $row->id;
		$level = $row->level;
		$id_kantor = $row->id_kantor;
		$cari = $this->input->post('cari'); 
	 
			if($level =='manager'){
				$this->db->order_by('date', 'desc');
				$query = $this->db->get('tb_history_barang_in_out', $limit, $start);

			}else{
				$this->db->order_by('date', 'desc');
				$this->db->where('id_admin',$id_admin);
				$this->db->where('id_kantor',$id_kantor);
				$query = $this->db->get('tb_history_barang_in_out', $limit, $start);
			}

		
    	
        return $query;
    }
    public function barang_expired_all($id_admin,$id_kantor,$level)
    {
        date_default_timezone_get('Asia/Jakarta');
        $tanggal_sekarang = date('Y-m-d');
        $tambah_tanggal = mktime(0,0,0,date('m')+4,date('01'),date('Y'));
        $tambah = date('Y-m-d',$tambah_tanggal);
        if($level =='manager'){
        	$this->db->order_by('tb_info_expired.expired_date', 'asc');
        	 
        	$this->db->where('tb_info_expired.expired_date <=',$tambah);
        	$query = $this->db->get('tb_info_expired');

        }else{
        	$this->db->order_by('tb_info_expired.expired_date', 'asc');
        	 
        	$this->db->where('id_admin',$id_admin);
        	$this->db->where('id_kantor',$id_kantor);
        	$this->db->where('tb_info_expired.expired_date <=',$tambah);
        	$query = $this->db->get('tb_info_expired');
        }
       
        return $query->result();
    } 
	public function data_barang_jual($id_admin,$id_kantor,$level)
    {
        date_default_timezone_get('Asia/Jakarta');
        
        $bulan= date('m')-1;
        $tahun = date('Y');
         if($level =='manager'){

	        $this->db->select(' tb_barang.id, tb_barang.nama_barang , SUM(tb_jual_detail.jumlah) as total_terjual');
	        $this->db->order_by('total_terjual', 'desc');
	        $this->db->GROUP_BY('tb_jual_detail.id_barang');
	        $this->db->limit(10);
	        $this->db->where('tb_barang.id = tb_jual_detail.id_barang ');
	        $this->db->where('month(tb_jual_detail.date)=',$bulan);
	        $this->db->where('year(tb_jual_detail.date)=',$tahun);
	        $query = $this->db->get('tb_barang, tb_jual_detail');
         }else{

	        $this->db->select(' tb_barang.id, tb_barang.nama_barang , SUM(tb_jual_detail.jumlah) as total_terjual');
	        $this->db->order_by('total_terjual', 'desc');
	        $this->db->GROUP_BY('tb_jual_detail.id_barang');
	         $this->db->limit(10);
	        $this->db->where('id_admin',$id_admin);
	        $this->db->where('id_kantor',$id_kantor);
	        $this->db->where('tb_barang.id = tb_jual_detail.id_barang ');
	        $this->db->where('month(tb_jual_detail.date)=',$bulan);
	        $this->db->where('year(tb_jual_detail.date)=',$tahun);
	        $query = $this->db->get('tb_barang, tb_jual_detail');
         }


        return $query->result();
    }  
	 
}