<?php 

class Kasir extends CI_Controller{


	function __construct(){

		parent::__construct();
		$this->load->model('m_kontak');/* sesuaikan dengan nama file pada model */
		$this->load->model('m_login'); 
		$this->load->model('m_admin'); 
		$this->load->model('m_kasir');
		$this->load->model('m_metode');
    $this->load->model('m_kat_member'); 
		$this->load->model('m_member');
		$this->load->model('m_kantor');
		$this->load->model('m_supliyer'); 
		$this->load->library('session');
		$this->load->library('upload');

		$this->load->helper(array('form', 'url','tanggal'));
		if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
			$this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
				<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
				<strong> Admin Bukan Admin </strong>Ulangi Kembali
				</div> ');

			redirect(base_url("")); 
			
		}


	}


	function index(){		
		$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin']= $row->id;
		$data['nama_admin']= $row->nama_admin;
		$data['id_kantor']= $row->id_kantor;

		$id_kantor = $row->id_kantor;



		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_kantor');
		$row = $query->row();
		$data['nama_kantor']= $row->nama_kantor;

		$data['barang'] = $this->m_kantor->kantor_stok_in($id_kantor); 
		$data['title1'] = 'Data Katagori Supliyer'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Supliyer';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['supliyer'] = $this->m_supliyer->supliyer(); 

		$this->load->view('master/header',$data); 
		$this->load->view('master/kasir/v_kasir');
		$this->load->view('master/footer',$data); 
		


	}
	function fetch()
	{
		$output = '';
		$query = '';

		if($this->input->post('query'))
		{
			$query = $this->input->post('query');
		}
		$data = $this->m_kasir->fetch_data($query);
		$output .= '
		<div class="table-responsive">
		<table class="table table-bordered table-striped">
		<tr>
		<th>Barcode id</th>
    <th>Img</th>
		<th>Nama Barang</th>
		<th>Harga Jual</th>
		<th>Harga Grosir</th>
		<th>Stok</th>

		</tr>
		';
		if($data->num_rows() > 0)
		{
			foreach($data->result() as $row)
			{
				$link = base_url();
        $username = $this->session->userdata("username");  
				$this->db->where('username',$username);
				$query3 = $this->db->get('tb_admin');
				$row2 = $query3->row(); 
				$id_kantor = $row2->id_kantor;

				$id_barang= $row->id;
				
				$sql_menuu = "SELECT stok_aplikasi FROM tb_stok WHERE  id_barang = '$id_barang' and id_kantor = '$id_kantor' ";
				$main_menuu = $this->db->query($sql_menuu)->result();
				foreach ($main_menuu as $mainkk) {
					$stok_aplikasi= $mainkk->stok_aplikasi;
				}
				$output .= '
				<tr  class=pilih data-id_barang='.$row->id.' data-nama_barang='.$row->nama_barang.' data-harga_jual_ecer='.$row->harga_jual_ecer.' data-barcode='.$row->barcode_ecer.'>
				
        <td><a onClick=masuk(this,'.$row->id.') href="#">'.$row->barcode_ecer.'</a></td>
        <td><a onClick=masuk(this,'.$row->id.') href="#"><img width=50px src='.$link.'images/barang/'.$row->foto.'></a></td>
				<td><a onClick=masuk(this,'.$row->id.') href="#">'.$row->nama_barang.'</a></td>
				<td>'.nominal($row->harga_jual_ecer).'</td>
				<td>'.$row->harga_grosir.' ( MinPembelian '.$row->min_grosir.' )</td>
				<td>'.$stok_aplikasi.'</td>

				</tr>
				';
			}
		}
		else
		{
			$output .= '<tr>
			<td colspan="5">No Data Found</td>
			</tr>';
		}
		$output .= '</table>';
		echo $output;
	}
	function fetch2()
	{
		$output = '';
		$query = '';

		if($this->input->post('query'))
		{
			$query = $this->input->post('query');
		}
		$data = $this->m_kasir->fetch_data($query);
		$output .= '
		<div class="table-responsive">
		<table class="table table-bordered table-striped">
		<tr>
		<th>Barcode id</th>
		<th>Nama Barang</th>
		<th>Harga Jual</th>
		<th>Harga Grosir</th>
		<th>Stok</th>


		</tr>
		';
		if($data->num_rows() > 0)
		{
			foreach($data->result() as $row)
			{
				$username = $this->session->userdata("username");  
				$this->db->where('username',$username);
				$query3 = $this->db->get('tb_admin');
				$row2 = $query3->row(); 
				$id_kantor = $row2->id_kantor;

				$id_barang= $row->id;
				
				$sql_menuu = "SELECT stok_aplikasi FROM tb_stok WHERE  id_barang = '$id_barang' and id_kantor = '$id_kantor' ";
				$main_menuu = $this->db->query($sql_menuu)->result();
				foreach ($main_menuu as $mainkk) {
					$stok_aplikasi= $mainkk->stok_aplikasi;
				}
				$output .= '
				<tr  class=pilih data-id_barang='.$row->id.' data-nama_barang='.$row->nama_barang.' data-harga_jual_ecer='.$row->harga_jual_ecer.' data-barcode='.$row->barcode_ecer.'>
				<td><a onClick=masuk(this,'.$row->id.') href="#">'.$row->barcode_ecer.'</a></td>
				<td><a onClick=masuk(this,'.$row->id.') href="#">'.$row->nama_barang.'</a></td>
				<td>'.$row->harga_jual_ecer.'</td>
				<td>'.$row->harga_grosir.' ('.$row->min_grosir.' )</td>
				<td>'.$stok_aplikasi.'</td>

				</tr>
				';
			}
		}
		else
		{
			$output .= '<tr>
			<td colspan="5">No Data Found</td>
			</tr>';
		}
		$output .= '</table>';
		echo $output;
	}
	function history_kasir(){		
		$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin']= $row->id;
		$data['nama_admin']= $row->nama_admin;
		$data['id_kantor']= $row->id_kantor;

		$id_admin = $row->id;
		$level = $row->level;
		$id_kantor = $row->id_kantor;

		$data['admin_login'] = $this->m_admin->data_admin_login();  


		if($level =='manager'){
			$this->db->order_by('date', 'desc');
			$query = $this->db->count_all('tb_kasir');

		}else{
			$this->db->order_by('date', 'desc');
			$this->db->where('id_admin',$id_admin);
			$this->db->where('id_kantor',$id_kantor);
			$query = $this->db->count_all('tb_kasir');
		}

		$config['base_url'] = base_url('kasir/history_kasir');

        $config['total_rows'] = $query; //total row
        $config['per_page'] = 20;  //show record per halaman
        $config["uri_segment"] = 3;  // uri parameter
        $config["num_links"] = 20;

        // Membuat Style pagination untuk BootStrap v4
        $config['first_link']       = 'First';
        $config['last_link']        = 'Last';
        $config['next_link']        = 'Next';
        $config['prev_link']        = 'Prev';
        $config['full_tag_open']    = '<div class="pagging text-center"><nav><ul class="pagination justify-content-center">';
        $config['full_tag_close']   = '</ul></nav></div>';
        $config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
        $config['num_tag_close']    = '</span></li>';
        $config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
        $config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
        $config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['next_tagl_close']  = '<span aria-hidden="true">&raquo;</span></span></li>';
        $config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['prev_tagl_close']  = '</span>Next</li>';
        $config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
        $config['first_tagl_close'] = '</span></li>';
        $config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['last_tagl_close']  = '</span></li>';

        $this->pagination->initialize($config);
        $data['page'] = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        //panggil function data_barangq yang ada pada mmodel m_barang.
        $data['data'] = $this->m_kasir->kasir_moneycash($config["per_page"], $data['page']);

        $data['pagination'] = $this->pagination->create_links();



        $this->load->view('master/header',$data); 
        $this->load->view('master/kasir/v_kasir_moneycash');
        $this->load->view('master/footer',$data); 



      }
      public function hold() {
      
        $username = $this->session->userdata("username");  
        $this->db->where('username',$username);
        $query = $this->db->get('tb_admin');
        $row = $query->row();
        $data['id_admin']= $row->id;
        $data['nama_admin']= $row->nama_admin;
        $data['id_kantor']= $row->id_kantor;
        $id_admin = $row->id;
        $id_kantor = $row->id_kantor;  


        $data=array(
       
        'hold'=> 1 ,
       
        
        
         );

        $this->db->where('id_admin',$id_admin);
        $this->db->where('id_kantor',$id_kantor);

        $this->db->update('tb_jual_kasir',$data);
        $this->session->set_flashdata('msg','warning-hold');
        redirect('kasir/log_in');
   
      } 
       public function hold_off() {
      
        $username = $this->session->userdata("username");  
        $this->db->where('username',$username);
        $query = $this->db->get('tb_admin');
        $row = $query->row();
        $data['id_admin']= $row->id;
        $data['nama_admin']= $row->nama_admin;
        $data['id_kantor']= $row->id_kantor;
        $id_admin = $row->id;
        $id_kantor = $row->id_kantor;  


        $data=array(
       
        'hold'=> 0 ,
       
        
        
         );

        $this->db->where('id_admin',$id_admin);
        $this->db->where('id_kantor',$id_kantor);

        $this->db->update('tb_jual_kasir',$data);
        $this->session->set_flashdata('msg','warning-holdd');
        redirect('kasir/log_in');
   
      } 
      function log_in(){		
      	$tgl = date('Ymd');

      	$username = $this->session->userdata("username");  
      	$this->db->where('username',$username);
      	$query = $this->db->get('tb_admin');
      	$row = $query->row();
      	$data['id_admin']= $row->id;
      	$data['nama_admin']= $row->nama_admin;
      	$data['id_kantor']= $row->id_kantor;
      	$id_admin = $row->id;
      	$id_kantor = $row->id_kantor;

      	//cek setoran
      	$this->db->where('id_admin',$id_admin);
      		$this->db->where('keterangan','logout-kasir');
      	$this->db->where("date(tb_kasir.date)='$tgl' ");
      	$query2 = $this->db->get('tb_kasir');
      	$rowkasir = $query2->row();

        //cek cek awal
        $this->db->where('id_admin',$id_admin);
          $this->db->where('keterangan','login-kasir');
        $this->db->where("date(tb_kasir.date)='$tgl' ");
        $query22 = $this->db->get('tb_kasir');
        $rowkasir2 = $query22->row();

      	if( $rowkasir->nominal != 0 or $rowkasir->nominal != '' ){
      			redirect('home');
      			$this->session->set_flashdata('msg','error-setor');

      	}else if( $rowkasir2->nominal == 0 or $rowkasir2->nominal == '' ){
            redirect('home');
            $this->session->set_flashdata('msg','error-awal');

        }else{
      		$this->db->where('id_kantor',$id_kantor);
	      	$query = $this->db->get('tb_kantor');
	      	$row = $query->row();
	      	$data['nama_kantor']= $row->nama_kantor;

	      	$data['barang'] = $this->m_kantor->kantor_stok_in($id_kantor); 
	      	$data['title1'] = 'Pelayanan Kasir'; 	
	      	$data['title2'] = 'Ubah Data'; 	
	      	$data['title3'] = 'Tambah Data';
	      	$data['title4'] = 'Kasir';
	      	$data['kontak'] = $this->m_kontak->kontak();
	      	$data['kantor'] = $this->m_kantor->kantor();
	      	$data['metode'] = $this->m_metode->metode();
	      	$data['admin'] = $this->m_admin->data_admin(); 
	      	$data['member'] = $this->m_member->member(); 
	      	$data['admin_login'] = $this->m_admin->data_admin_login();  
	      	$data['supliyer'] = $this->m_supliyer->supliyer();
	      	$data['keranjang'] = $this->m_kasir->keranjang($id_admin,$id_kantor);
	      	$data['sub_total'] = $this->m_kasir->sub_total_pembelian($id_admin,$id_kantor);
	      	$data['jumlah_pembelian'] = $this->m_kasir->jum_pembelian($id_admin,$id_kantor);
          $data['kat_member'] = $this->m_kat_member->kat_member(); 


	      	$this->load->view('master/kasir/index',$data); 

      	}


      	




      }
      function get_autocomplete(){
      	if (isset($_GET['term'])) {
      		$result = $this->m_kasir->search_blog($_GET['term']);
      		if (count($result) > 0) {
      			foreach ($result as $row)
      				$arr_result[] = array(
      					'label'			=> $row->blog_title,
      					'description'	=> $row->blog_description,
      				);
      			echo json_encode($arr_result);
      		}
      	}
      }
      function get_autocomplete_barang(){
      	if (isset($_GET['term'])) {
      		$result = $this->m_kasir->pencarian($_GET['term']);
      		if (count($result) > 0) {
      			foreach ($result as $row)
      				$arr_result[] = array(
      					'label'			=> $row->nama_barang,
      					'description'	=> $row->id,
      					'namabarang'	=> $row->id,
      				);
      			echo json_encode($arr_result);
      		}
      	}
      }
      function logout(){		
      	$username = $this->session->userdata("username");  
      	$this->db->where('username',$username);
      	$query = $this->db->get('tb_admin');
      	$row = $query->row();
      	$data['id_admin']= $row->id;
      	$data['nama_admin']= $row->nama_admin;
      	$data['id_kantor']= $row->id_kantor;

      	$id_kantor = $row->id_kantor;



      	$this->db->where('id_kantor',$id_kantor);
      	$query = $this->db->get('tb_kantor');
      	$row = $query->row();
      	$data['nama_kantor']= $row->nama_kantor;

      	$data['barang'] = $this->m_kantor->kantor_stok_in($id_kantor); 
      	$data['title1'] = 'Data Katagori Supliyer'; 	
      	$data['title2'] = 'Ubah Data'; 	
      	$data['title3'] = 'Tambah Data';
      	$data['title4'] = 'Supliyer';
      	$data['kontak'] = $this->m_kontak->kontak();
      	$data['kantor'] = $this->m_kantor->kantor();
      	$data['admin'] = $this->m_admin->data_admin(); 
      	$data['admin_login'] = $this->m_admin->data_admin_login();  
      	$data['supliyer'] = $this->m_supliyer->supliyer(); 


      	$this->load->view('master/header',$data); 
      	$this->load->view('master/kasir/v_kasir2',$data); 
      	$this->load->view('master/footer',$data);




      }



      public function hapus_keranjang(){

      	$id= $this->input->post('id');
      	$password= $this->input->post('password');
      	$password_admin= $this->input->post('password_admin'); 

      	if($password == $password_admin){
      		$this->db->delete('tb_jual_kasir', array('id' => $id)); 

      		redirect('kasir/log_in');

      	}else{

      		$this->session->set_flashdata('msg','password-salah');
      		redirect('kasir/log_in');
      	}





      } 

      public function code_simpan_keranjang()
      {	 


      	$barcode= $this->input->post('barcode');
      	$id_admin= $this->input->post('id_admin');
      	$id_kantor= $this->input->post('id_kantor');
      	$jum_masuk= $this->input->post('jumlah');
      	$jenis= $this->input->post('jenis');
		//tampil data barang	
      	$this->db->where('barcode_ecer',$barcode);
      	$query = $this->db->get('tb_barang');
      	$row = $query->row();
		//data ecer
      	$id_barang = $row->id;
      	$harga_beli_ecer = $row->harga_beli_ecer;
      	$harga_jual_ecer = $row->harga_jual_ecer;
		//data dos
      	$harga_beli_dos = $row->harga_beli_dos;
      	$harga_jual_dos = $row->harga_jual_dos;
		//data grosir
      	$harga_grosir = $row->harga_grosir;
      	$min_grosir = $row->min_grosir;

		//cek stok barang gudang	
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$query = $this->db->get('tb_stok');
      	$stok = $query->row();
      	$cek_stok = $stok->stok_aplikasi;

		//cek   barang sudah dientri di tb_jual_kasir
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$this->db->where('id_admin',$id_admin);
        $this->db->where('hold','0');
      	$this->db->where('jenis',$jenis);
      	$query = $this->db->get('tb_jual_kasir');
      	$kasir = $query->row();
      	$cek_jenis = $kasir->jenis;
      	$cek_id_barang = $kasir->id_barang;
      	$cek_jum_jual = $kasir->jumlah;

      	$new_jumlah = $cek_jum_jual + $jum_masuk;




 		// seleksi barang grosir atau tidak
      	if($new_jumlah >= $min_grosir AND $min_grosir !=0 ){

      		$new_harga_jual = $harga_grosir;
      		$new_total = $new_harga_jual * $new_jumlah ;

      	}else{
      		$new_harga_jual = $harga_jual_ecer;
      		$new_total = $new_harga_jual * $new_jumlah ;


      	}

      	if(empty($new_harga_jual) )	{
      		$this->session->set_flashdata('msg','error-kosong');
      		redirect('kasir/log_in');

      	}else if($cek_stok <= 0){
      		$this->session->set_flashdata('msg','error-stok');
      		redirect('kasir/log_in');

      	}else if($new_jumlah > $cek_stok ){
      		$this->session->set_flashdata('msg','warning-stok');
      		redirect('kasir/log_in');
      	}else{

				//cek barang apakah barang sudah masuk keranjang admin
      		if($cek_id_barang == $id_barang and $cek_jenis == 'ecer' ){

      			$data=array(

      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $new_jumlah,
      				'harga_total'=> $new_total,

      			);
					//update keranjang
      			$this->db->where('id_barang',$id_barang);
      			$this->db->where('id_admin',$id_admin);
      			$this->db->where('id_kantor',$id_kantor);
      			$this->db->where('jenis',$jenis);
            $this->db->where('hold','0');
      			$this->db->update('tb_jual_kasir',$data);

      			redirect('kasir/log_in');

      		}else{
					//barang belum entri keranjang

      			$data=array(
      				'id'=>  null,
      				'id_barang'=> $id_barang,
      				'id_admin'=> $id_admin,
      				'id_kantor'=> $id_kantor,
      				'harga_beli'=> $harga_beli_ecer,
      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $new_jumlah,
      				'harga_total'=> $new_total,
      				'jenis'=> $jenis,

      			);
      			$this->db->insert('tb_jual_kasir',$data);
      			redirect('kasir/log_in');
      		}	

      	}	





      } 
      public function code_simpan_keranjang_cari()
      {	 


      	$id_barang= $this->input->post('id_barang');
      	$id_admin= $this->input->post('id_admin');
      	$id_kantor= $this->input->post('id_kantor');
      	$jum_masuk= $this->input->post('jumlah');
      	$jenis= $this->input->post('jenis');
		//tampil data barang	
      	$this->db->where('id',$id_barang);
      	$query = $this->db->get('tb_barang');
      	$row = $query->row();
		//data ecer
      	$harga_beli_ecer = $row->harga_beli_ecer;
      	$harga_jual_ecer = $row->harga_jual_ecer;
		//data dos
      	$harga_beli_dos = $row->harga_beli_dos;
      	$harga_jual_dos = $row->harga_jual_dos;
		//data grosir
      	$harga_grosir = $row->harga_grosir;
      	$min_grosir = $row->min_grosir;

		//cek stok barang gudang	
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$query = $this->db->get('tb_stok');
      	$stok = $query->row();
      	$cek_stok = $stok->stok_aplikasi;

		//cek   barang sudah dientri di tb_jual_kasir
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$this->db->where('id_admin',$id_admin);
        $this->db->where('hold','0');
      	$this->db->where('jenis',$jenis);
      	$query = $this->db->get('tb_jual_kasir');
      	$kasir = $query->row();
      	$cek_jenis = $kasir->jenis;
      	$cek_id_barang = $kasir->id_barang;
      	$cek_jum_jual = $kasir->jumlah;

      	$new_jumlah = $cek_jum_jual + $jum_masuk;




 		// seleksi barang grosir atau tidak
      	if($new_jumlah >= $min_grosir AND $min_grosir !=0 ){

      		$new_harga_jual = $harga_grosir;
      		$new_total = $new_harga_jual * $new_jumlah ;

      	}else{
      		$new_harga_jual = $harga_jual_ecer;
      		$new_total = $new_harga_jual * $new_jumlah ;


      	}

      	if(empty($new_harga_jual) )	{
      		$this->session->set_flashdata('msg','error-kosong');
      		redirect('kasir/log_in');

      	}else if($cek_stok <= 0){
      		$this->session->set_flashdata('msg','error-stok');
      		redirect('kasir/log_in');

      	}else if($new_jumlah > $cek_stok ){
      		$this->session->set_flashdata('msg','warning-stok');
      		redirect('kasir/log_in');
      	}else{

				//cek barang apakah barang sudah masuk keranjang admin
      		if($cek_id_barang == $id_barang and $cek_jenis == 'ecer' ){

      			$data=array(

      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $new_jumlah,
      				'harga_total'=> $new_total,

      			);
					//update keranjang
      			$this->db->where('id_barang',$id_barang);
      			$this->db->where('id_admin',$id_admin);
      			$this->db->where('id_kantor',$id_kantor);
      			$this->db->where('jenis',$jenis);
            $this->db->where('hold','0');
      			$this->db->update('tb_jual_kasir',$data);

      			redirect('kasir/log_in');

      		}else{
					//barang belum entri keranjang

      			$data=array(
      				'id'=>  null,
      				'id_barang'=> $id_barang,
      				'id_admin'=> $id_admin,
      				'id_kantor'=> $id_kantor,
      				'harga_beli'=> $harga_beli_ecer,
      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $new_jumlah,
      				'harga_total'=> $new_total,
      				'jenis'=> $jenis,

      			);
      			$this->db->insert('tb_jual_kasir',$data);
      			redirect('kasir/log_in');
      		}	

      	}	





      } 
      public function ubah_code_keranjang()
      {	 


      	$id_barang= $this->input->post('id_barang');
      	$id_admin= $this->input->post('id_admin');
      	$id_kantor= $this->input->post('id_kantor');
      	$jum_masuk= $this->input->post('jumlah_ubah');
      	$jenis= $this->input->post('jenis');
		//tampil data barang	
      	$this->db->where('id',$id_barang);
      	$query = $this->db->get('tb_barang');
      	$row = $query->row();
		//data ecer
      	$harga_beli_ecer = $row->harga_beli_ecer;
      	$harga_jual_ecer = $row->harga_jual_ecer;
		//data dos
      	$harga_beli_dos = $row->harga_beli_dos;
      	$harga_jual_dos = $row->harga_jual_dos;
		//data grosir
      	$harga_grosir = $row->harga_grosir;
      	$min_grosir = $row->min_grosir;

		//cek stok barang gudang	
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$query = $this->db->get('tb_stok');
      	$stok = $query->row();
      	$cek_stok = $stok->stok_aplikasi;

		//cek   barang sudah dientri di tb_jual_kasir
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$this->db->where('id_admin',$id_admin);
      	$this->db->where('jenis',$jenis);
        $this->db->where('hold','0');
      	$query = $this->db->get('tb_jual_kasir');
      	$kasir = $query->row();
      	$cek_jenis = $kasir->jenis;
      	$cek_id_barang = $kasir->id_barang;
      	$cek_jum_jual = $kasir->jumlah;

      	$new_jumlah = $cek_jum_jual + $jum_masuk;




 		// seleksi barang grosir atau tidak
      	if($jum_masuk >= $min_grosir AND $min_grosir !=0 ){

      		$new_harga_jual = $harga_grosir;
      		$new_total = $new_harga_jual * $jum_masuk ;

      	}else{
      		$new_harga_jual = $harga_jual_ecer;
      		$new_total = $new_harga_jual * $jum_masuk ;


      	}

      	if(empty($new_harga_jual) )	{
      		$this->session->set_flashdata('msg','error-kosong');
      		redirect('kasir/log_in');

      	}else if($cek_stok <= 0){
      		$this->session->set_flashdata('msg','error-stok');
      		redirect('kasir/log_in');

      	}else if($jum_masuk > $cek_stok ){
      		$this->session->set_flashdata('msg','warning-stok');
      		redirect('kasir/log_in');
      	}else{

				//cek barang apakah barang sudah masuk keranjang admin
      		if($cek_id_barang == $id_barang and $cek_jenis == $jenis  ){

      			$data=array(

      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $jum_masuk,
      				'harga_total'=> $new_total,

      			);
					//update keranjang
      			$this->db->where('id_barang',$id_barang);
      			$this->db->where('id_admin',$id_admin);
      			$this->db->where('id_kantor',$id_kantor);
      			$this->db->where('jenis',$jenis);
            $this->db->where('hold','0');
      			$this->db->update('tb_jual_kasir',$data);

      			redirect('kasir/log_in');

      		}else{
					//barang belum entri keranjang

      			$data=array(
      				'id'=>  null,
      				'id_barang'=> $id_barang,
      				'id_admin'=> $id_admin,
      				'id_kantor'=> $id_kantor,
      				'harga_beli'=> $harga_beli_ecer,
      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $new_jumlah,
      				'harga_total'=> $new_total,

      			);
      			$this->db->insert('tb_jual_kasir',$data);
      			redirect('kasir/log_in');
      		}	

      	}	





      } 
      public function code_simpan_keranjang_dos()
      {	 


      	$id_barang= $this->input->post('id_barang');
      	$id_admin= $this->input->post('id_admin');
      	$id_kantor= $this->input->post('id_kantor');
      	$jum_masuk= $this->input->post('jumlah');
      	$jenis= $this->input->post('jenis');

		//tampil data barang	
      	$this->db->where('id',$id_barang);
      	$query = $this->db->get('tb_barang');
      	$row = $query->row();

		//data dos
      	$harga_beli_dos = $row->harga_beli_dos; 
      	$harga_jual_dos = $row->harga_jual_dos;
		//data grosir
      	$isiperdos = $row->isi;

      	$harga_beli_dos = $harga_beli_dos/ $isiperdos;
      	$new_harga_jual = $harga_jual_dos/ $isiperdos;
      	$newpembelian = $isiperdos * $jum_masuk;


		//cek stok barang gudang	
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$query = $this->db->get('tb_stok');
      	$stok = $query->row();
      	$cek_stok = $stok->stok_aplikasi;

		//cek   barang sudah dientri di tb_jual_kasir
      	$this->db->where('id_barang',$id_barang);
      	$this->db->where('id_kantor',$id_kantor);
      	$this->db->where('id_admin',$id_admin);
      	$this->db->where('jenis',$jenis);
        $this->db->where('hold','0');
      	$query = $this->db->get('tb_jual_kasir');
      	$kasir = $query->row();
      	$cek_id_barang = $kasir->id_barang;
      	$cek_jum_jual = $kasir->jumlah;

      	$new_jumlah = $cek_jum_jual + $newpembelian;

      	$new_jumdos= $new_jumlah / $isiperdos;




      	if(empty($new_harga_jual) )	{
      		$this->session->set_flashdata('msg','error-kosong');
      		redirect('kasir/log_in');

      	}else if($cek_stok <= 0){
      		$this->session->set_flashdata('msg','error-stok');
      		redirect('kasir/log_in');

      	}else if($new_jumlah > $cek_stok ){
      		$this->session->set_flashdata('msg','warning-stok');
      		redirect('kasir/log_in');
      	}else{

				//cek barang apakah barang sudah masuk keranjang admin
      		if($cek_id_barang == $id_barang ){
      			$new_total =  $harga_jual_dos * $new_jumdos;
      			$data=array(

      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $new_jumlah,
      				'harga_total'=> $new_total,

      			);
					//update keranjang
      			$this->db->where('id_barang',$id_barang);
      			$this->db->where('id_admin',$id_admin);
      			$this->db->where('id_kantor',$id_kantor);
      			$this->db->where('jenis',$jenis);
            $this->db->where('hold','0');
      			$this->db->update('tb_jual_kasir',$data);

      			redirect('kasir/log_in');

      		}else{
					//barang belum entri keranjang
      			$new_total =  $harga_jual_dos * $jum_masuk;
      			$data=array(
      				'id'=>  null,
      				'id_barang'=> $id_barang,
      				'id_admin'=> $id_admin,
      				'id_kantor'=> $id_kantor,
      				'harga_beli'=> $harga_beli_dos,
      				'harga_jual'=> $new_harga_jual,
      				'jumlah'=> $new_jumlah,
      				'harga_total'=> $new_total,
      				'jenis'=> $jenis,


      			);
      			$this->db->insert('tb_jual_kasir',$data);
      			redirect('kasir/log_in');
      		}	

      	}	





      }
      public function code_start()
      {	 
      	$data=array(
      		'id'=>  null,
      		'id_admin'=> $this->input->post('id_admin'),

      		'id_kantor'=> $this->input->post('id_kantor'),
      		'nominal'=> $this->input->post('uang_tunai'),
      		'keterangan'=> 'login-kasir',


      	);

      	$this->db->insert('tb_kasir',$data);
      	$this->session->set_flashdata('msg','success-login_kasir');
      	redirect('kasir/log_in');





      }  


      public function code_logout()
      {	 
      	$setor = $this->input->post('uang_tunai');
      	$id_admin = $this->input->post('id_admin');


      	$tanggal_sekarang = date('Ymd');
      	$sql_menu = "SELECT sum(total) as total FROM tb_transaksi WHERE  id_admin = '$id_admin' and date(date)=' $tanggal_sekarang' ";
      	$main_menu = $this->db->query($sql_menu)->result();
      	foreach ($main_menu as $a) {
      		$total_transaksi = $a->total;

      	}

      	$sql_menux = "SELECT nominal FROM tb_kasir WHERE  id_admin = '$id_admin' and date(date)=' $tanggal_sekarang' ";
      	$main_menux = $this->db->query($sql_menux)->result();
      	foreach ($main_menux as $ax) {
      		$nominal_awal = $ax->nominal;

      	}  


      	$selisih  = $setor -  ($total_transaksi +  $nominal_awal);
      	$data=array(
      		'id'=>  null,
      		'id_admin'=> $this->input->post('id_admin'),

      		'id_kantor'=> $this->input->post('id_kantor'),
      		'nominal'=> $this->input->post('uang_tunai'),
      		'keterangan'=> 'logout-kasir',
      		'selisih'=> $selisih,
      		'awal_moneycash'=> $nominal_awal,

      		'total_transaksi'=> $total_transaksi,

      	);

      	$this->db->insert('tb_kasir',$data);





      	$this->session->set_flashdata('msg','success-logout-kasir');
      	redirect('home');





      }  

      public function code_ubah() {


      	$data=array(

      		'nama_supliyer'=> $this->input->post('nama_supliyer'),
      		'url_supliyer'=> url_title($this->input->post('nama_supliyer')),
      		'nama_petugas'=> $this->input->post('nama_petugas'),
      		'alamat'=> $this->input->post('alamat'),
      		'no_hp'=> $this->input->post('no_hp'),


      	);

      	$this->db->where('id_supliyer',$this->input->post('id'));
      	$this->db->update('tb_supliyer',$data);
      	$this->session->set_flashdata('msg','success-edit');
      	redirect('supliyer');

      } 

      function get_barang(){
      	$kode=$this->input->post('kode');
      	$data=$this->m_kasir->get_data_barang_bykode($kode);
      	echo json_encode($data);
      }
      public function code_simpan_pembelian() {
      	$id_member= $this->input->post('id_member');
      	$id_admin= $this->input->post('id_admin');
      	$id_kantor= $this->input->post('id_kantor');

      	$point= $this->input->post('point');
      	$sub_total= $this->input->post('sub_total');
      	$potongan= $this->input->post('potongan');
      	$total= $this->input->post('total');
      	$bayar= $this->input->post('bayar');
      	$kembali= $this->input->post('kembali');
      	$metode_bayar= $this->input->post('metode_bayar');
      	$ket_metode= $this->input->post('ket_metode');
      	$diskon= $this->input->post('diskon');
        $min_diskon= $this->input->post('min_diskon');
      	$hitung_diskon= $diskon /100;

		//kodetransaksi
      	$date = date("dmY");
      	$query = $this->db->query("SELECT max(id_transaksi) as max_id FROM tb_transaksi WHERE id_transaksi LIKE '$date%' "); 
      	$row = $query->row_array();
      	$max_id = $row['max_id']; 
      	$max_id1 =(int) substr($max_id,8,4);
      	$kode_tr = $max_id1 +1;
      	$newkode = $date.sprintf("%04s",$kode_tr);


        if($sub_total <= 0 ){
            $this->session->set_flashdata('pss','<div class="alert alert-info alert-dismissible">
                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                <strong> Gagal, Total Belanjaan Kosong !</strong>
                </div> ');
              redirect('cetak/form_kosong/');

        }else{
        	if(empty($id_member)){
        		$id_member= '1';

        		if($potongan > 0){
        			$this->session->set_flashdata('pss','<div class="alert alert-info alert-dismissible">
        				<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
        				<strong> Gagal, Tidak Boleh ada Potongan!</strong>
        				</div> ');
        			redirect('cetak/form_kosong/');
        		}else{

        			if($kembali < 0){
        				$this->session->set_flashdata('pss','<div class="alert alert-info alert-dismissible">
        					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
        					<strong> Gagal, Nominal Bayar Salah !</strong>
        					</div> ');
        				redirect('cetak/form_kosong/');
        			}else{

        				$sql = "SELECT * FROM tb_jual_kasir  where id_admin='$id_admin' and id_kantor='$id_kantor' and hold ='0' ";
        				$cari = $this->db->query($sql)->result();
        				foreach ($cari as $data) {
  				        	//input data barmasuk
        					$data1=array(

        						'id'=>null,

        						'id_barang'			=>  $data->id_barang, 
        						'id_kantor'			=>  $data->id_kantor,
        						'harga_beli'		=>  $data->harga_beli,
        						'harga_jual'		=>  $data->harga_jual,
        						'jumlah'			=>  $data->jumlah,
        						'harga_total'		=>  $data->harga_total,
        						'id_admin'			=>  $data->id_admin, 	
        						'date'				=>  $data->date,


        						'id_transaksi'=>  $newkode
        					);

        					$this->db->insert('tb_jual_detail',$data1);


  				        //input data history
        					$data2=array(

        						'id_barang'			=>  $data->id_barang, 
        						'id_kantor'			=>  $data->id_kantor,
        						'jumlah'			=>  $data->jumlah,
        						'id_admin'			=>  $data->id_admin,
        						'date'				=>  $data->date,
        						'keterangan'=>  'terjual',

        						'id_transaksi'=>  $newkode, 

        					);

        					$this->db->insert('tb_history_barang_in_out',$data2);


        					$id_barang = $data->id_barang;
        					$jum_keluar = $data->jumlah;

        					$this->db->where('id_barang',$id_barang);
        					$this->db->where('id_kantor',$id_kantor);
        					$query1	 = $this->db->get('tb_stok');
        					$row1 	 = $query1->row();
        					$cek_stok	 = $row1->stok_aplikasi;
        					$new_stok =   $cek_stok - $jum_keluar ;


  			 			//update stok gudang
        					$datax=array(

        						'stok_aplikasi'=> $new_stok

        					);
        					$this->db->where('id_barang',$id_barang);
        					$this->db->where('id_kantor',$id_kantor);
        					$this->db->update('tb_stok',$datax);

        				}
  					// simpan pembayaran
        				$data4=array(

        					'id_transaksi'=>  $newkode, 
        					'id_member'=>  $id_member, 
        					'id_kantor'=>  $this->input->post('id_kantor'), 
        					'sub_total'=>  $this->input->post('sub_total'), 
        					'potongan'=>  $this->input->post('potongan'),

        					'point'=>  $this->input->post('point'), 
                  'point_member'=>  0, 
        					'total'=>  $this->input->post('total'), 
        					'bayar'=>  $this->input->post('bayar'), 
        					'kembali'=>  $this->input->post('kembali'), 
        					'id_admin'=>  $this->input->post('id_admin'), 

        					'status' => 'LUNAS',
        					'metode_bayar'=>  $this->input->post('metode_bayar') ,
        					'ket_metode'=>  $this->input->post('ket_metode') 

        				);
        				$this->db->insert('tb_transaksi',$data4); 

  					//update point member
        				$new_point = $cek_point - $potongan;
        				$dataxx=array(

        					'point'=> $new_point

        				);
        				$this->db->where('id_member',$id_member);
        				$this->db->update('tb_member',$dataxx);


  					//hapus barjual kasir
        				$hapus = "DELETE FROM tb_jual_kasir where id_admin='$id_admin' and id_kantor='$id_kantor'   and hold ='0' ";
        				$data = $this->db->query($hapus);



        				redirect('cetak/form_cetak/'.$newkode);	

        			}
        		}


        	}else{
  			//cek Point
        		$id_member= $this->input->post('id_member');
        		$this->db->where('id_member',$id_member);
        		$query = $this->db->get('tb_member');
        		$row = $query->row();
        		$cek_point= $row->point;

        		if($potongan > $point){
        			$this->session->set_flashdata('pss','<div class="alert alert-info alert-dismissible">
        				<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
        				<strong> Gagal, Potongan Melebihi Point Member!</strong>
        				</div> ');
        			redirect('cetak/form_kosong/');
        		}else{
        			if($kembali < 0){
        				$this->session->set_flashdata('pss','<div class="alert alert-info alert-dismissible">
        					<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
        					<strong> Gagal, Nominal Bayar Salah !</strong>
        					</div> ');
        				redirect('cetak/form_kosong/');
        			}else{

        				$sql = "SELECT * FROM tb_jual_kasir  where id_admin='$id_admin' and id_kantor='$id_kantor' ";
        				$cari = $this->db->query($sql)->result();
        				foreach ($cari as $data) {
  				        	//input data barmasuk
        					$data1=array(

        						'id'=>null,

        						'id_barang'			=>  $data->id_barang, 
        						'id_kantor'			=>  $data->id_kantor,
        						'harga_beli'		=>  $data->harga_beli,
        						'harga_jual'		=>  $data->harga_jual,
        						'jumlah'			=>  $data->jumlah,
        						'harga_total'		=>  $data->harga_total,
        						'id_admin'			=>  $data->id_admin,
        						'date'				=>  $data->date,


        						'id_transaksi'=>  $newkode
        					);

        					$this->db->insert('tb_jual_detail',$data1);


  				        //input data history
        					$data2=array(

        						'id_barang'			=>  $data->id_barang, 
        						'id_kantor'			=>  $data->id_kantor,
        						'jumlah'			=>  $data->jumlah,
        						'id_admin'			=>  $data->id_admin,
        						'date'				=>  $data->date,
        						'keterangan'=>  'terjual',

        						'id_transaksi'=>  $newkode, 

        					);

        					$this->db->insert('tb_history_barang_in_out',$data2);


        					$id_barang = $data->id_barang;
        					$jum_keluar = $data->jumlah;

        					$this->db->where('id_barang',$id_barang);
        					$this->db->where('id_kantor',$id_kantor);
        					$query1	 = $this->db->get('tb_stok');
        					$row1 	 = $query1->row();
        					$cek_stok	 = $row1->stok_aplikasi;
        					$new_stok =   $cek_stok - $jum_keluar ;


  			 			//update stok gudang
        					$datax=array(

        						'stok_aplikasi'=> $new_stok

        					);
        					$this->db->where('id_barang',$id_barang);
        					$this->db->where('id_kantor',$id_kantor);
        					$this->db->update('tb_stok',$datax);

        				}
  					

  						//update point member
        				$new_point = $cek_point - $potongan;
        				$dataxx=array(

        					'point'=> $new_point

        				);
        				$this->db->where('id_member',$id_member);
        				$this->db->update('tb_member',$dataxx);
  						//history point member
        				$data5=array(

        					'id'=> null, 
        					'id_member'=>  $id_member, 
        					'point'=>  $potongan, 
        					'id_transaksi'=>   $newkode,


        					'status' => 'potongan',

        				);
        				$this->db->insert('tb_history_point_member',$data5);



  						  //cek jumlah_pembelian Kecuali Rokok 

        				$sql_menu = "SELECT SUM(tb_jual_kasir.harga_total) AS total_belanja FROM
        				tb_barang, tb_jual_kasir, tb_katagori

        				WHERE
        				tb_katagori.id_katagori = tb_barang.id_katagori AND
        				tb_barang.id = tb_jual_kasir.id_barang AND
        				tb_katagori.id_katagori <> '1' AND
        				tb_jual_kasir.id_admin = '$id_admin'  AND
        				tb_jual_kasir.id_kantor = '$id_kantor'    ";
        				$main_menu = $this->db->query($sql_menu)->result();
        				foreach ($main_menu as $main) {

        					$total_belanja= $main->total_belanja;
        				}

                if( $total_belanja >= $min_diskon){
                  $pesentase_diskon = $total_belanja * ($diskon/100);

                  $this->db->where('id_member',$id_member);
                  $query2 = $this->db->get('tb_member');
                  $row2 = $query2->row();
                  $cek_point2= $row2->point;
                  //penambahan Point
                  $new_point2 = $cek_point2 + $pesentase_diskon;
                  $dataxxxx=array(

                  'point'=> $new_point2

                  );
                  $this->db->where('id_member',$id_member);
                  $this->db->update('tb_member',$dataxxxx);

                  $data6=array(

                  'id'=> null, 
                  'id_member'=>  $id_member, 
                  'point'=>  $pesentase_diskon, 
                  'id_transaksi'=>   $newkode,
                  'status' => 'tambahan',

                  );
                  $this->db->insert('tb_history_point_member',$data6);

                }else{
                  $this->db->where('id_member',$id_member);
                  $query2 = $this->db->get('tb_member');
                  $row2 = $query2->row();
                  $new_point2= $row2->point;
                  $pesentase_diskon=0;
                }
        				







                // simpan pembayaran
                $data4=array(

                  'id_transaksi'=>  $newkode, 
                  'id_member'=>  $id_member, 
                  'id_kantor'=>  $this->input->post('id_kantor'), 
                  'sub_total'=>  $this->input->post('sub_total'), 
                  'potongan'=>  $this->input->post('potongan'),

                  'point'=> $this->input->post('point'), 
                  'tambahan_point'=>  $pesentase_diskon, 
                  'point_member'=>  $new_point2,

                  'total'=>  $this->input->post('total'), 
                  'bayar'=>  $this->input->post('bayar'), 
                  'kembali'=>  $this->input->post('kembali'), 
                  'id_admin'=>  $this->input->post('id_admin'), 

                  'status' => 'LUNAS',
                  'metode_bayar'=>  $this->input->post('metode_bayar'),
                  'ket_metode'=>  $this->input->post('ket_metode') 

                );
                $this->db->insert('tb_transaksi',$data4); 

  					//hapus barjual kasir
        				$hapus = "DELETE FROM tb_jual_kasir where id_admin='$id_admin' and id_kantor='$id_kantor'    ";
        				$data = $this->db->query($hapus);



        				redirect('cetak/form_cetak/'.$newkode);

        			}


        		}

        	}	

        }  

      } 


    }