<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Kasir - CodeIgniter 3</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --secondary: #3f37c9;
            --success: #4cc9f0;
            --warning: #f8961e;
            --danger: #e5383b;
            --dark: #212529;
            --light: #f8f9fa;
            --grosir1: #90be6d;
            --grosir2: #43aa8b;
            --grosir3: #4d908e;
            --grosir4: #577590;
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            padding-top: 20px;
            padding-bottom: 20px;
        }
        
        .card {
            border-radius: 15px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            border: none;
            margin-bottom: 20px;
            transition: transform 0.3s;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            background: var(--primary);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            font-weight: 600;
            padding: 15px 20px;
        }
        
        .btn-primary {
            background: var(--primary);
            border-color: var(--primary);
        }
        
        .btn-primary:hover {
            background: var(--secondary);
            border-color: var(--secondary);
        }
        
        .btn-success {
            background: var(--success);
            border-color: var(--success);
        }
        
        .btn-warning {
            background: var(--warning);
            border-color: var(--warning);
        }
        
        .table thead th {
            background: var(--primary);
            color: white;
        }
        
        .discount-btn, .pay-btn {
            margin: 2px;
            min-width: 60px;
        }
        
        .search-results {
            position: absolute;
            background: white;
            z-index: 1000;
            width: 100%;
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid #ddd;
            border-radius: 5px;
            display: none;
        }
        
        .search-item {
            padding: 10px;
            border-bottom: 1px solid #eee;
            cursor: pointer;
            transition: background 0.2s;
        }
        
        .search-item:hover {
            background: #f8f9fa;
        }
        
        .cart-item {
            transition: background 0.3s;
        }
        
        .cart-item:hover {
            background: rgba(67, 97, 238, 0.05);
        }
        
        .summary-card {
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
        }
        
        .summary-value {
            font-weight: 600;
            font-size: 1.1em;
        }
        
        .payment-section {
            background: #eef5ff;
            border-radius: 10px;
            padding: 15px;
        }
        
        .input-group-text {
            background: #e9ecef;
        }
        
        .footer {
            background: var(--primary);
            color: white;
            padding: 15px 0;
            border-radius: 0 0 15px 15px;
        }
        
        .level-badge {
            font-size: 0.75rem;
            padding: 3px 8px;
            margin-left: 5px;
            border-radius: 10px;
        }
        
        .level-lv1 {
            background: var(--grosir1);
            color: white;
        }
        
        .level-lv2 {
            background: var(--grosir2);
            color: white;
        }
        
        .level-lv3 {
            background: var(--grosir3);
            color: white;
        }
        
        .level-lv4 {
            background: var(--grosir4);
            color: white;
        }
        
        .price-info {
            font-size: 0.85rem;
            color: #6c757d;
            margin-top: 3px;
        }
        
        .price-level {
            display: flex;
            justify-content: space-between;
            margin-bottom: 3px;
        }
        
        .modal-level {
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row mb-4">
            <div class="col-md-12 text-center">
                <h1 class="display-4 fw-bold text-primary">
                    <i class="fas fa-cash-register me-2"></i>Sistem Kasir Grosir
                </h1>
                <p class="lead text-muted">Penyesuaian harga berdasarkan level pembelian</p>
            </div>
        </div>
        
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-barcode me-2"></i>Input Barang
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-bold">Scan Barcode (1D)</label>
                                    <div class="input-group">
                                        <span class="input-group-text"><i class="fas fa-barcode"></i></span>
                                        <input type="text" class="form-control" id="barcode" placeholder="Scan barcode..." autofocus>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-bold">Cari Nama Barang</label>
                                    <div class="position-relative">
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fas fa-search"></i></span>
                                            <input type="text" class="form-control" id="cari-barang" placeholder="Cari barang...">
                                        </div>
                                        <div class="search-results" id="hasil-cari"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card mt-3">
                            <div class="card-header bg-success text-white">
                                <i class="fas fa-shopping-cart me-2"></i>Keranjang Belanja
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover mb-0">
                                        <thead>
                                            <tr>
                                                <th>Nama Barang</th>
                                                <th>Harga</th>
                                                <th>Qty</th>
                                                <th>Total</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody id="keranjang">
                                            <!-- Keranjang akan diisi oleh JavaScript -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card summary-card">
                    <div class="card-header bg-primary text-white">
                        <i class="fas fa-receipt me-2"></i>Ringkasan Pembayaran
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Sub Total:</span>
                                <span class="summary-value" id="sub-total">Rp 0</span>
                            </div>
                            
                            <div class="d-flex justify-content-between mb-3">
                                <span>Potongan:</span>
                                <span class="summary-value text-danger" id="potongan-value">Rp 0</span>
                            </div>
                            
                            <div class="d-flex justify-content-between mb-3">
                                <span><strong>Total:</strong></span>
                                <span class="summary-value fw-bold" id="total">Rp 0</span>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label fw-bold">Potongan Harga</label>
                                <div class="d-flex flex-wrap">
                                    <button class="btn btn-outline-primary discount-btn" data-discount="0">Rp 0</button>
                                    <button class="btn btn-outline-primary discount-btn" data-discount="5000">Rp 5.000</button>
                                    <button class="btn btn-outline-primary discount-btn" data-discount="10000">Rp 10.000</button>
                                    <button class="btn btn-outline-primary discount-btn" data-discount="20000">Rp 20.000</button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="payment-section">
                            <div class="mb-3">
                                <label class="form-label fw-bold">Pembayaran</label>
                                <div class="input-group mb-2">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" class="form-control" id="bayar" min="0" value="0">
                                </div>
                                
                                <div class="d-flex flex-wrap">
                                    <button class="btn btn-outline-success pay-btn" data-pay="50000">50K</button>
                                    <button class="btn btn-outline-success pay-btn" data-pay="100000">100K</button>
                                    <button class="btn btn-outline-success pay-btn" data-pay="200000">200K</button>
                                    <button class="btn btn-outline-success pay-btn" data-pay="500000">500K</button>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label fw-bold">Kembalian</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="text" class="form-control" id="kembali" value="0" readonly>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label fw-bold">Metode Pembayaran</label>
                                <select class="form-select" id="metode-bayar">
                                    <option value="tunai">Tunai</option>
                                    <option value="debit">Kartu Debit</option>
                                    <option value="kredit">Kartu Kredit</option>
                                    <option value="transfer">Transfer Bank</option>
                                </select>
                            </div>
                        </div>
                        
                        <button class="btn btn-success btn-lg w-100 mt-3" id="simpan-transaksi">
                            <i class="fas fa-check-circle me-2"></i>Simpan Transaksi
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="row mt-4">
            <div class="col-12">
                <div class="card">
                    <div class="footer text-center">
                        <p class="mb-0">Sistem Kasir Grosir &copy; <?= date('Y') ?> - Dibuat dengan CodeIgniter 3</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Modal Level Harga -->
    <div class="modal fade" id="levelModal" tabindex="-1" aria-labelledby="levelModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title" id="levelModalLabel">Level Harga Grosir</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Level</th>
                                    <th>Min. Pembelian</th>
                                    <th>Harga Grosir</th>
                                </tr>
                            </thead>
                            <tbody id="level-body">
                                <tr>
                                    <td>Ecer</td>
                                    <td>-</td>
                                    <td id="harga-ecer">Rp 0</td>
                                </tr>
                                <tr>
                                    <td>Level 1</td>
                                    <td id="min-lv1">0</td>
                                    <td id="harga-lv1">Rp 0</td>
                                </tr>
                                <tr>
                                    <td>Level 2</td>
                                    <td id="min-lv2">0</td>
                                    <td id="harga-lv2">Rp 0</td>
                                </tr>
                                <tr>
                                    <td>Level 3</td>
                                    <td id="min-lv3">0</td>
                                    <td id="harga-lv3">Rp 0</td>
                                </tr>
                                <tr>
                                    <td>Level 4</td>
                                    <td id="min-lv4">0</td>
                                    <td id="harga-lv4">Rp 0</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        $(document).ready(function() {
            let keranjang = [];
            let subTotal = 0;
            let potongan = 0;
            let total = 0;
            let currentLevelData = {};
            
            // Format angka ke Rupiah
            function formatRupiah(angka) {
                return new Intl.NumberFormat('id-ID', { 
                    style: 'currency', 
                    currency: 'IDR',
                    minimumFractionDigits: 0
                }).format(angka);
            }
            
            // Perbarui ringkasan pembayaran
            function updateRingkasan() {
                subTotal = keranjang.reduce((sum, item) => sum + (item.harga_jual * item.qty), 0);
                total = subTotal - potongan;
                
                $('#sub-total').text(formatRupiah(subTotal));
                $('#potongan-value').text(formatRupiah(potongan));
                $('#total').text(formatRupiah(total));
                hitungKembali();
            }
            
            // Hitung kembali
            function hitungKembali() {
                const bayar = parseFloat($('#bayar').val()) || 0;
                const kembali = bayar - total;
                $('#kembali').val(kembali > 0 ? formatRupiah(kembali) : formatRupiah(0));
            }
            
            // Tampilkan keranjang
            function tampilkanKeranjang() {
                let html = '';
                
                if (keranjang.length === 0) {
                    html = `<tr>
                        <td colspan="5" class="text-center py-4 text-muted">
                            <i class="fas fa-shopping-cart fa-2x mb-2"></i>
                            <p>Keranjang belanja kosong</p>
                        </td>
                    </tr>`;
                } else {
                    keranjang.forEach((item, index) => {
                        const totalHarga = item.harga_jual * item.qty;
                        let levelBadge = '';
                        
                        // Tentukan level berdasarkan harga yang digunakan
                        if (item.harga_jual === item.harga_jual_ecer) {
                            levelBadge = '';
                        } else if (item.harga_jual === item.harga_grosir_lv1) {
                            levelBadge = '<span class="badge level-badge level-lv1">Level 1</span>';
                        } else if (item.harga_jual === item.harga_grosir_lv2) {
                            levelBadge = '<span class="badge level-badge level-lv2">Level 2</span>';
                        } else if (item.harga_jual === item.harga_grosir_lv3) {
                            levelBadge = '<span class="badge level-badge level-lv3">Level 3</span>';
                        } else if (item.harga_jual === item.harga_grosir_lv4) {
                            levelBadge = '<span class="badge level-badge level-lv4">Level 4</span>';
                        }
                        
                        html += `
                        <tr class="cart-item">
                            <td>
                                <div>${item.nama_barang}</div>
                                <div class="price-info">
                                    <a href="#" class="text-decoration-none modal-level" data-id="${item.id}" data-index="${index}">
                                        <i class="fas fa-info-circle me-1"></i>Detail Level Harga
                                    </a>
                                </div>
                            </td>
                            <td>
                                ${formatRupiah(item.harga_jual)} ${levelBadge}
                            </td>
                            <td>
                                <div class="input-group input-group-sm" style="width: 110px;">
                                    <button class="btn btn-outline-secondary minus" data-index="${index}">-</button>
                                    <input type="number" class="form-control text-center qty" value="${item.qty}" min="1" data-index="${index}">
                                    <button class="btn btn-outline-secondary plus" data-index="${index}">+</button>
                                </div>
                            </td>
                            <td>${formatRupiah(totalHarga)}</td>
                            <td>
                                <button class="btn btn-danger btn-sm hapus" data-index="${index}">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </td>
                        </tr>`;
                    });
                }
                
                $('#keranjang').html(html);
                updateRingkasan();
            }
            
            // Tambah barang ke keranjang
            function tambahKeKeranjang(barang) {
                const existingItem = keranjang.find(item => item.id === barang.id);
                
                if (existingItem) {
                    existingItem.qty += 1;
                    // Cek apakah jumlah baru memenuhi level grosir
                    updateHargaBerdasarkanLevel(existingItem);
                } else {
                    const newItem = {
                        id: barang.id,
                        nama_barang: barang.nama_barang,
                        harga_beli_ecer: barang.harga_beli_ecer,
                        harga_jual_ecer: barang.harga_jual_ecer,
                        harga_grosir_lv1: barang.harga_grosir_lv1,
                        harga_grosir_lv2: barang.harga_grosir_lv2,
                        harga_grosir_lv3: barang.harga_grosir_lv3,
                        harga_grosir_lv4: barang.harga_grosir_lv4,
                        min_grosir_lv1: barang.min_grosir_lv1,
                        min_grosir_lv2: barang.min_grosir_lv2,
                        min_grosir_lv3: barang.min_grosir_lv3,
                        min_grosir_lv4: barang.min_grosir_lv4,
                        qty: 1,
                        harga_jual: barang.harga_jual_ecer
                    };
                    keranjang.push(newItem);
                }
                
                tampilkanKeranjang();
            }
            
            // Update harga berdasarkan level pembelian
            function updateHargaBerdasarkanLevel(item) {
                // Reset harga ke ecer terlebih dahulu
                item.harga_jual = item.harga_jual_ecer;
                
                // Cek level grosir dari level tertinggi ke terendah
                if (item.min_grosir_lv4 && item.qty >= item.min_grosir_lv4 && item.harga_grosir_lv4 > 0) {
                    item.harga_jual = item.harga_grosir_lv4;
                } else if (item.min_grosir_lv3 && item.qty >= item.min_grosir_lv3 && item.harga_grosir_lv3 > 0) {
                    item.harga_jual = item.harga_grosir_lv3;
                } else if (item.min_grosir_lv2 && item.qty >= item.min_grosir_lv2 && item.harga_grosir_lv2 > 0) {
                    item.harga_jual = item.harga_grosir_lv2;
                } else if (item.min_grosir_lv1 && item.qty >= item.min_grosir_lv1 && item.harga_grosir_lv1 > 0) {
                    item.harga_jual = item.harga_grosir_lv1;
                }
            }
            
            // Tampilkan level harga di modal
            function showLevelHarga(id_barang, index) {
                $.get('<?= site_url('kasirupdate/get_level_harga') ?>?id_barang=' + id_barang, function(data) {
                    if (data) {
                        $('#harga-ecer').text(formatRupiah(keranjang[index].harga_jual_ecer));
                        $('#harga-lv1').text(formatRupiah(data.harga_grosir_lv1));
                        $('#harga-lv2').text(formatRupiah(data.harga_grosir_lv2));
                        $('#harga-lv3').text(formatRupiah(data.harga_grosir_lv3));
                        $('#harga-lv4').text(formatRupiah(data.harga_grosir_lv4));
                        
                        $('#min-lv1').text(data.min_grosir_lv1);
                        $('#min-lv2').text(data.min_grosir_lv2);
                        $('#min-lv3').text(data.min_grosir_lv3);
                        $('#min-lv4').text(data.min_grosir_lv4);
                        
                        // Tandai level yang sedang digunakan
                        const currentLevel = keranjang[index].harga_jual;
                        $('tbody tr').removeClass('table-primary');
                        
                        if (currentLevel === data.harga_grosir_lv1) {
                            $('tbody tr:eq(1)').addClass('table-primary');
                        } else if (currentLevel === data.harga_grosir_lv2) {
                            $('tbody tr:eq(2)').addClass('table-primary');
                        } else if (currentLevel === data.harga_grosir_lv3) {
                            $('tbody tr:eq(3)').addClass('table-primary');
                        } else if (currentLevel === data.harga_grosir_lv4) {
                            $('tbody tr:eq(4)').addClass('table-primary');
                        } else {
                            $('tbody tr:eq(0)').addClass('table-primary');
                        }
                        
                        $('#levelModal').modal('show');
                    }
                }, 'json');
            }
            
            // Event handler untuk scan barcode
            $('#barcode').on('keypress', function(e) {
                if (e.which === 13) {
                    const barcode = $(this).val().trim();
                    if (barcode) {
                        $.get('<?= site_url('kasirupdate/get_barang_by_barcode') ?>?barcode=' + barcode, function(data) {
                            if (data) {
                                tambahKeKeranjang(data);
                                $('#barcode').val('').focus();
                            } else {
                                alert('Barang tidak ditemukan!');
                            }
                        }, 'json');
                    }
                }
            });
            
            // Event handler untuk pencarian barang
            $('#cari-barang').on('input', function() {
                const keyword = $(this).val().trim();
                if (keyword.length >= 3) {
                    $.get('<?= site_url('kasirupdate/cari_barang') ?>?keyword=' + keyword, function(data) {
                        let html = '';
                        if (data.length > 0) {
                            data.forEach(barang => {
                                html += `<div class="search-item" data-id="${barang.id}" 
                                          data-nama="${barang.nama_barang}" 
                                          data-harga="${barang.harga_jual_ecer}"
                                          data-hargalv1="${barang.harga_grosir_lv1}"
                                          data-hargalv2="${barang.harga_grosir_lv2}"
                                          data-hargalv3="${barang.harga_grosir_lv3}"
                                          data-hargalv4="${barang.harga_grosir_lv4}"
                                          data-minlv1="${barang.min_grosir_lv1}"
                                          data-minlv2="${barang.min_grosir_lv2}"
                                          data-minlv3="${barang.min_grosir_lv3}"
                                          data-minlv4="${barang.min_grosir_lv4}">
                                    <strong>${barang.nama_barang}</strong>
                                    <div class="text-muted">${formatRupiah(barang.harga_jual_ecer)}</div>
                                </div>`;
                            });
                        } else {
                            html = '<div class="search-item text-muted p-3">Barang tidak ditemukan</div>';
                        }
                        $('#hasil-cari').html(html).show();
                    }, 'json');
                } else {
                    $('#hasil-cari').hide();
                }
            });
            
            // Event handler untuk memilih hasil pencarian
            $(document).on('click', '.search-item', function() {
                const id = $(this).data('id');
                const nama = $(this).data('nama');
                const harga = $(this).data('harga');
                
                tambahKeKeranjang({
                    id: id,
                    nama_barang: nama,
                    harga_beli_ecer: harga,
                    harga_jual_ecer: harga,
                    harga_grosir_lv1: $(this).data('hargalv1'),
                    harga_grosir_lv2: $(this).data('hargalv2'),
                    harga_grosir_lv3: $(this).data('hargalv3'),
                    harga_grosir_lv4: $(this).data('hargalv4'),
                    min_grosir_lv1: $(this).data('minlv1'),
                    min_grosir_lv2: $(this).data('minlv2'),
                    min_grosir_lv3: $(this).data('minlv3'),
                    min_grosir_lv4: $(this).data('minlv4')
                });
                
                $('#cari-barang').val('');
                $('#hasil-cari').hide();
            });
            
            // Event handler untuk tombol potongan
            $('.discount-btn').on('click', function() {
                potongan = parseInt($(this).data('discount'));
                updateRingkasan();
            });
            
            // Event handler untuk tombol bayar cepat
            $('.pay-btn').on('click', function() {
                const nominal = parseInt($(this).data('pay'));
                $('#bayar').val(nominal);
                hitungKembali();
            });
            
            // Event handler untuk input bayar
            $('#bayar').on('input', hitungKembali);
            
            // Event handler untuk tambah/kurang/hapus item
            $(document).on('click', '.plus', function() {
                const index = $(this).data('index');
                keranjang[index].qty += 1;
                updateHargaBerdasarkanLevel(keranjang[index]);
                tampilkanKeranjang();
            });
            
            $(document).on('click', '.minus', function() {
                const index = $(this).data('index');
                if (keranjang[index].qty > 1) {
                    keranjang[index].qty -= 1;
                    updateHargaBerdasarkanLevel(keranjang[index]);
                    tampilkanKeranjang();
                }
            });
            
            $(document).on('change', '.qty', function() {
                const index = $(this).data('index');
                const qty = parseInt($(this).val()) || 1;
                keranjang[index].qty = qty < 1 ? 1 : qty;
                updateHargaBerdasarkanLevel(keranjang[index]);
                tampilkanKeranjang();
            });
            
            $(document).on('click', '.hapus', function() {
                const index = $(this).data('index');
                keranjang.splice(index, 1);
                tampilkanKeranjang();
            });
            
            // Event handler untuk tombol detail level harga
            $(document).on('click', '.modal-level', function(e) {
                e.preventDefault();
                const id_barang = $(this).data('id');
                const index = $(this).data('index');
                showLevelHarga(id_barang, index);
            });
            
            // Event handler untuk simpan transaksi
            $('#simpan-transaksi').on('click', function() {
                if (keranjang.length === 0) {
                    alert('Keranjang belanja masih kosong!');
                    return;
                }
                
                const bayar = parseFloat($('#bayar').val()) || 0;
                const kembali = bayar - total;
                
                if (bayar < total) {
                    alert('Jumlah pembayaran kurang!');
                    return;
                }
                
                const transaksi = {
                    sub_total: subTotal,
                    potongan: potongan,
                    bayar: bayar,
                    kembali: kembali > 0 ? kembali : 0,
                    metode_bayar: $('#metode-bayar').val()
                };
                
                const detail = keranjang.map(item => ({
                    id: item.id,
                    nama_barang: item.nama_barang,
                    harga_beli: item.harga_beli_ecer,
                    harga_jual: item.harga_jual,
                    qty: item.qty,
                    harga_total: item.harga_jual * item.qty
                }));
                
                $.post('<?= site_url('kasirupdate/simpan_transaksi') ?>', {
                    transaksi: JSON.stringify(transaksi),
                    detail: JSON.stringify(detail)
                }, function(response) {
                    if (response.status === 'success') {
                        alert('Transaksi berhasil disimpan!');
                        // Reset keranjang dan form
                        keranjang = [];
                        potongan = 0;
                        tampilkanKeranjang();
                        $('#bayar').val(0);
                        hitungKembali();
                        $('#barcode').focus();
                    } else {
                        alert('Terjadi kesalahan: ' + response.message);
                    }
                }, 'json');
            });
            
            // Inisialisasi tampilan
            tampilkanKeranjang();
        });
    </script>
</body>
</html>