<?php 

class M_kantor extends CI_Model{
	public function __construct()
	{
		$this->load->database();
	}
	 
	public function kantor()
	{
		$this->db->order_by('id_kantor', 'desc');
		$query = $this->db->get('tb_kantor');
		return $query->result();
	} 
	public function kantor_stok($id_kantor)
	{
		
		$this->db->order_by('stok_aplikasi', 'ASC');
		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_stok');
		return $query->result();
	} 
	public function kantor_stok_baru($id_kantor)
	{
		$this->db->select('*');    
		$this->db->from('tb_stok');
		$this->db->join('tb_barang', 'tb_stok.id_barang = tb_barang.id');
		$this->db->join('tb_kantor', 'tb_stok.id_kantor = tb_kantor.id_kantor');
		$this->db->order_by('tb_stok.stok_aplikasi', 'ASC');
		$this->db->order_by('tb_barang.harga_beli_ecer', 'DESC');
		$this->db->where('tb_kantor.id_kantor',$id_kantor);
		$query = $this->db->get();
		return $query->result();
	} 
    public function kantor_stok_all()
    {
        $this->db->order_by('stok_aplikasi', 'ASC'); 
        
        $query = $this->db->get('tb_stok');
        return $query->result();
    } 

	public function kantor_stok_in($id_kantor)
	{
		$this->db->order_by('stok_aplikasi', 'ASC'); 
		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_stok');
		return $query->result();
	} 
	public function keranjang($id_admin,$id_kantor)
	{
		 
		$this->db->order_by('id', 'desc');
	 	$this->db->where('id_admin',$id_admin);
		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_faktur_detail_keranjang');
		return $query->result();
	} 
	public function keranjang_dropout($id_admin,$id_kantor)
	{
		 
		$this->db->order_by('id', 'desc');
	 	$this->db->where('id_admin',$id_admin);
		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_dropout_detail_keranjang');
		return $query->result();
	} 
	public function detail_faktur($id_faktur)
	{
		 
		 
	 	$this->db->where('id_faktur',$id_faktur);
		 
		$query = $this->db->get('tb_faktur_detail');
		return $query->result();
	} 
    public function detail_drop_out($id_dropout)
    {
         
         
        $this->db->where('id_dropout',$id_dropout);
         
        $query = $this->db->get('tb_dropout_detail');
        return $query->result();
    } 

	function faktur(){
		date_default_timezone_set('Asia/Jakarta');
        $tanggal = date("Y-m-d");
        $tgl_awal = $this->input->post('tgl_awal');
        $tgl_akhir = $this->input->post('tgl_akhir');
        $id_kantor = $this->input->post('id_kantor');
        $jenis = $this->input->post('jenis');
        $status=$this->input->post('status');
         
        if(empty($tgl_awal)){
        	$username = $this->session->userdata("username");  
        	$this->db->where('username',$username);
        	$query = $this->db->get('tb_admin');
        	$row = $query->row();
        	$data['id_admin']= $row->id;
        	$data['nama_admin']= $row->nama_admin;
        	$data['id_kantor']= $row->id_kantor;
        	$id_admin2 = $row->id;
        	$level = $row->level;
        	$id_kantor2 = $row->id_kantor;

        		$bulan=date('m');
        		$tahun=date('Y');
	        	if($level == 'manager' or $level == 'admin')	{
	        		 $query = $this->db->query("select  * from tb_faktur where MONTH(tb_faktur.date) = '$bulan' and YEAR(tb_faktur.date) = '$tahun' and tb_faktur.id_kantor ='$id_kantor2'  order by tb_faktur.date desc ");
	        	}else{
	        		 $query = $this->db->query("select  * from tb_faktur where MONTH(tb_faktur.date) = '$bulan' and YEAR(tb_faktur.date) = '$tahun' and order by tb_faktur.date desc ");

	        	}
               
        	 
        }else{

           
        	if( $id_kantor == 'semua' &&   $status =='semua' ){
        		 $cari="where  tb_faktur.date BETWEEN '$tgl_awal' AND '$tgl_akhir' AND tb_faktur.jenis='$jenis'  ";

        	}else if(  $id_kantor == 'semua' &&   $status !='semua' ){
        		 $cari="where  
                           		 tb_faktur.status ='$status' and
                 				tb_faktur.date BETWEEN '$tgl_awal' AND '$tgl_akhir' AND tb_faktur.jenis='$jenis' ";

        	}else if(  $id_kantor != 'semua' &&   $status =='semua' ){
        		 $cari="where tb_faktur.id_kantor ='$id_kantor'   and
                 				tb_faktur.date BETWEEN '$tgl_awal' AND '$tgl_akhir' AND tb_faktur.jenis='$jenis'  ";

        	}else{
        		 $cari="where tb_faktur.id_kantor ='$id_kantor' and 
                           		 tb_faktur.status ='$status' and
                 				tb_faktur.date BETWEEN '$tgl_awal' AND '$tgl_akhir' AND tb_faktur.jenis='$jenis'  ";

        	}	



			$query = $this->db->query("select  * from tb_faktur $cari  order by tb_faktur.date desc ");


        }

       
        return $query->result();
    }

    function dropout(){
    	date_default_timezone_set('Asia/Jakarta');
        $tanggal = date("Y-m-d");
        $tgl_awal = $this->input->post('tgl_awal');
        $tgl_akhir = $this->input->post('tgl_akhir');
        $id_kantor = $this->input->post('id_kantor');
        
        $status=$this->input->post('status');
         
        if(empty($tgl_awal)){
        	$username = $this->session->userdata("username");  
        	$this->db->where('username',$username);
        	$query = $this->db->get('tb_admin');
        	$row = $query->row();
        	$data['id_admin']= $row->id;
        	$data['nama_admin']= $row->nama_admin;
        	$data['id_kantor']= $row->id_kantor;
        	$id_admin2 = $row->id;
        	$level = $row->level;
        	$id_kantor2 = $row->id_kantor;

        		$bulan=date('m');
        		$tahun=date('Y');
	        	if($level == 'manager'  or $level == 'admin')	{
	        		 $query = $this->db->query("select  * from tb_dropout where MONTH(tb_dropout.date) = '$bulan' and YEAR(tb_dropout.date) = '$tahun' and tb_dropout.id_kantor ='$id_kantor2'  order by tb_dropout.date desc ");
	        	}else{
	        		 $query = $this->db->query("select  * from tb_dropout where MONTH(tb_dropout.date) = '$bulan' and YEAR(tb_dropout.date) = '$tahun' and order by tb_dropout.date desc ");

	        	}
               
        	 
        }else{

           
        	if( $id_kantor == 'semua' &&   $status =='semua' ){
        		 $cari="where  tb_dropout.date BETWEEN '$tgl_awal' AND '$tgl_akhir'    ";

        	}else if(  $id_kantor == 'semua' &&   $status !='semua' ){
        		 $cari="where  
                           		 tb_dropout.status ='$status' and
                 				tb_dropout.date BETWEEN '$tgl_awal' AND '$tgl_akhir'   ";

        	}else if(  $id_kantor != 'semua' &&   $status =='semua' ){
        		 $cari="where tb_dropout.id_kantor ='$id_kantor'   and
                 				tb_dropout.date BETWEEN '$tgl_awal' AND '$tgl_akhir'    ";

        	}else{
        		 $cari="where tb_dropout.id_kantor ='$id_kantor' and 
                           		 tb_dropout.status ='$status' and
                 				tb_dropout.date BETWEEN '$tgl_awal' AND '$tgl_akhir'   ";

        	}	



			$query = $this->db->query("select  * from tb_dropout $cari  order by tb_dropout.date desc ");


        }

       
        return $query->result();
    }
	 
}